/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.player;

import com.yungnickyoung.minecraft.ribbits.module.ItemModule;
import com.yungnickyoung.minecraft.ribbits.services.Services;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_3222;

public class PlayerInstrumentTracker {
    private static final float AUDIENCE_RANGE = 32.0f;
    private static final ConcurrentHashMap<class_1657, Set<class_1657>> performerToAudienceMap = new ConcurrentHashMap();

    public static void onServerTick() {
        for (class_1657 performer : performerToAudienceMap.keySet()) {
            PlayerInstrumentTracker.updateAudienceForPerformer(performer);
        }
    }

    private static void updateAudienceForPerformer(class_1657 performer) {
        HashSet<class_1657> audienceMembers = new HashSet<class_1657>((Collection)performerToAudienceMap.get(performer));
        if (performer.method_31481() || !performer.method_5998(performer.method_6058()).method_31574((class_1792)ItemModule.MARACA.get())) {
            PlayerInstrumentTracker.removePerformer(performer);
            return;
        }
        List playersInRange = performer.method_37908().method_18467(class_1657.class, performer.method_5829().method_1009(32.0, 32.0, 32.0));
        playersInRange.forEach(player -> {
            if (!audienceMembers.contains(player)) {
                audienceMembers.add((class_1657)player);
                Services.PLATFORM.startHearingMaraca((class_3222)performer, (class_3222)player);
            }
        });
        audienceMembers.removeIf(player -> {
            if (player.method_31481() || !playersInRange.contains(player)) {
                Services.PLATFORM.stopHearingMaraca((class_3222)performer, (class_3222)player);
                return true;
            }
            return false;
        });
        performerToAudienceMap.put(performer, audienceMembers);
    }

    public static void addPerformer(class_1657 performer) {
        performerToAudienceMap.put(performer, new HashSet());
    }

    public static void removePerformer(class_1657 performer) {
        for (class_1657 audienceMember : performerToAudienceMap.get(performer)) {
            Services.PLATFORM.stopHearingMaraca((class_3222)performer, (class_3222)audienceMember);
        }
        performerToAudienceMap.remove(performer);
    }
}

